<?php
/*
 * Copyright 2016 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_CloudNaturalLanguage_Sentence extends Google_Model
{
  protected $sentimentType = 'Google_Service_CloudNaturalLanguage_Sentiment';
  protected $sentimentDataType = '';
  protected $textType = 'Google_Service_CloudNaturalLanguage_TextSpan';
  protected $textDataType = '';

  public function setSentiment(Google_Service_CloudNaturalLanguage_Sentiment $sentiment)
  {
    $this->sentiment = $sentiment;
  }
  public function getSentiment()
  {
    return $this->sentiment;
  }
  public function setText(Google_Service_CloudNaturalLanguage_TextSpan $text)
  {
    $this->text = $text;
  }
  public function getText()
  {
    return $this->text;
  }
}
